<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Medias extends Model 
{

    protected $table = 'medias';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function matieres()
    {
        return $this->morphedByMany('App\Models\Matiere', 'photoable');
    }

    public function eleves()
    {
        return $this->morphedByMany('App\Models\Eleve', 'photoable');
    }

    public function professeurs()
    {
        return $this->belongsTo('App\Models\Professeur');
    }

}